/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import oracle.ldap.util.AccessDeniedException;
import oracle.ldap.util.AccountDisabledException;
import oracle.ldap.util.AccountInactiveException;
import oracle.ldap.util.AccountLockedException;
import oracle.ldap.util.AcctIPLockedException;
import oracle.ldap.util.AuthFailureException;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.GraceLoginException;
import oracle.ldap.util.Group;
import oracle.ldap.util.IllegalValueException;
import oracle.ldap.util.InvalidRootOrclctxException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.MinimumLengthException;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.MultipleUserException;
import oracle.ldap.util.MustChangeException;
import oracle.ldap.util.NoSuchUserException;
import oracle.ldap.util.NumericCharacterException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.PasswordExpiredException;
import oracle.ldap.util.PasswordExpiredWarningException;
import oracle.ldap.util.PasswordInHistoryException;
import oracle.ldap.util.PasswordNullException;
import oracle.ldap.util.PasswordPolicyControl;
import oracle.ldap.util.PasswordPolicyException;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.SetPropertiesException;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.SubscriberNotFoundException;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class User
extends LDAPEntry {
    private String entryGUID = null;
    private String inUserId = null;
    private String inSearchBase = null;
    private String searchFilter = null;
    private int userIdType = -1;
    private String subIdName = null;
    private int subIdType = -1;
    private Subscriber subscriber = null;
    private String[] userSearchBase = null;
    private String userNickNameAttr = null;
    private String userPrincipalAttr = null;
    private String userNameWinAttr = null;
    private boolean toBeAutoProvisioned = false;
    private String[] attrList = new String[0];
    private SearchResult entryEnum = null;
    private String enumBase = null;
    private static String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    public static final String[] radContainerObjList = new String[]{"top", "orclcontainer", "orclauxiliaryguid"};
    public static final String[] extPrefRefObjList = new String[]{"top", "orclreferenceobject"};
    public static final String[] radObjList = new String[]{"top", "orclresourcedescriptor"};
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    public static int CREDTYPE_PASSWD = 0;
    public static int EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR = 0;

    protected User(DirContext dirContext, String string, String string2, PropertySet propertySet) {
        super(dirContext, string, propertySet);
        this.entryGUID = string2;
        this.validated = true;
    }

    protected User(DirContext dirContext, String string, String string2, String string3, Subscriber subscriber, SearchResult searchResult) {
        this(dirContext, string, string2, null);
        this.subscriber = subscriber;
        this.entryGUID = string2;
        this.enumBase = string3;
        this.entryEnum = searchResult;
    }

    public User(DirContext dirContext, int n, String string, Subscriber subscriber, boolean bl) throws UtilException {
        this(dirContext, n, string, 0, null, subscriber, null, null, null, new String[0], false, bl);
    }

    public User(DirContext dirContext, int n, String string, int n2, String string2, boolean bl) throws UtilException {
        this(dirContext, n, string, n2, string2, null, null, null, null, new String[0], false, bl);
    }

    protected User(DirContext dirContext, int n, String string, int n2, String string2, Subscriber subscriber, String string3, String[] stringArray, String string4, String[] stringArray2, boolean bl, boolean bl2) throws UtilException {
        super(dirContext, string);
        if (string == null) {
            throw new ParameterException(resBundle.getString("PARAMETER_NULL") + ":  inUserIdName");
        }
        if (string == "") {
            throw new UtilException(resBundle.getString("PARAMETER_INVALID") + ":  inUserIdName");
        }
        if (n != Util.IDTYPE_DN && n != Util.IDTYPE_SIMPLE && n != Util.IDTYPE_WINDOWS && n != Util.IDTYPE_KERB_PRINCIPAL && n != Util.IDTYPE_GUID) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  inUserIdType");
        }
        this.subIdType = n2;
        this.subIdName = string2;
        this.subscriber = subscriber;
        this.attrList = stringArray2;
        this.userSearchBase = stringArray;
        this.userNickNameAttr = string4;
        this.inSearchBase = string3;
        this.toBeAutoProvisioned = bl;
        this.inUserId = string;
        this.userIdType = n;
        if (bl2) {
            this.resolve(dirContext);
        }
    }

    public PropertySetCollection getExtendedProperties(DirContext dirContext, int n, String[] stringArray, String string) throws UtilException {
        this.resolve(dirContext);
        String string2 = this.locateSubscriber(dirContext);
        String[] stringArray2 = new String[]{"orclguid"};
        PropertySetCollection propertySetCollection = this.getProperties(dirContext, stringArray2, true);
        PropertySet propertySet = propertySetCollection.getPropertySet(0);
        String string3 = (String)propertySet.getProperty(0).getValue(0);
        String string4 = null;
        if (n != EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  propType");
        }
        string4 = new String("cn=Resource Access Descriptor");
        String string5 = new String(string4 + ",orclOwnerGUID=" + string3 + ",cn=Extended Properties,cn=OracleContext," + string2);
        try {
            return Util.getEntryDetails(dirContext, string5, string, 2, stringArray);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            String string6 = resBundle.getString("GENERAL_ERROR_SEARCH") + ":  getExtendedProperties";
            if (namingException instanceof NoPermissionException) {
                throw new AccessDeniedException(string6, namingException);
            }
            if (UtilException.getLDAPErrorCode(namingException) == 32) {
                return new PropertySetCollection();
            }
            throw new GeneralErrorException(string6, namingException);
        }
    }

    public PropertySetCollection getExtendedProperties(DirContext dirContext, int n, String[] stringArray) throws UtilException {
        return this.getExtendedProperties(dirContext, n, stringArray, "(objectclass=*)");
    }

    public void setExtendedProperties(DirContext dirContext, int n, String string, ModPropertySet modPropertySet) throws UtilException {
        Object object;
        this.resolve(dirContext);
        String string2 = this.locateSubscriber(dirContext);
        String string3 = this.getGUID(dirContext);
        String string4 = null;
        if (n != EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  propType");
        }
        string4 = new String("cn=Resource Access Descriptor");
        String string5 = new String(string4 + ",orclOwnerGUID=" + string3 + ",cn=Extended Properties,cn=OracleContext," + string2);
        PropertySetCollection propertySetCollection = null;
        String string6 = null;
        boolean bl = this.sameCtxUser(dirContext);
        try {
            object = null;
            object = bl ? new String[]{"dn", "orclusermodifiable"} : new String[]{"dn"};
            propertySetCollection = Util.ldapSearch(dirContext, string5, string, 2, (String[])object);
        }
        catch (UtilException utilException) {
            if (utilException instanceof CommunicationErrorException) {
                throw utilException;
            }
            throw new SetPropertiesException("Requested RAD does not exist.", utilException);
        }
        if (propertySetCollection == null || propertySetCollection.isEmpty()) {
            throw new SetPropertiesException("Requested RAD does not exist");
        }
        if (propertySetCollection.size() > 1) {
            throw new SetPropertiesException("Multiple RADs encountered");
        }
        if (bl) {
            object = "TRUE";
            try {
                object = propertySetCollection.getUniquePropertyValue("orclusermodifiable");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!((String)object).equalsIgnoreCase("TRUE")) {
                throw new SetPropertiesException("User is not allowed to modify this RAD");
            }
        }
        string6 = propertySetCollection.getPropertySet(0).getDN();
        try {
            Util.ldapModify(dirContext, string6, modPropertySet);
        }
        catch (UtilException utilException) {
            if (utilException instanceof CommunicationErrorException) {
                throw utilException;
            }
            throw new SetPropertiesException("Cannot Update Extended Properties", utilException.returnNamingException());
        }
    }

    public void createExtendedProperties(DirContext dirContext, int n, ModPropertySet modPropertySet) throws UtilException {
        String string;
        Object object;
        String string2;
        String string3;
        block13: {
            this.resolve(dirContext);
            String string4 = this.locateSubscriber(dirContext);
            string3 = this.getGUID(dirContext);
            Object var6_6 = null;
            if (n == EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR) {
                string2 = "orclownerguid=" + string3 + ",cn=Extended Properties,cn=oracleContext," + string4;
                try {
                    Util.ldapSearch(dirContext, string2, "objectclass=*", 0, new String[]{"dn"});
                }
                catch (UtilException utilException) {
                    if (utilException.isNamingException() && utilException.returnNamingException() instanceof NameNotFoundException) {
                        object = new ModPropertySet();
                        ((ModPropertySet)object).addProperty(0, "objectclass", extPrefRefObjList);
                        ((ModPropertySet)object).addProperty(0, "orclownerguid", string3);
                        ((ModPropertySet)object).addProperty(0, "seealso", this.entryDN);
                        Util.ldapAdd(dirContext, string2, (ModPropertySet)object);
                    }
                    throw utilException;
                }
                string2 = "cn=Resource Access Descriptor," + string2;
                try {
                    Util.ldapSearch(dirContext, string2, "objectclass=*", 0, new String[]{"dn"});
                }
                catch (UtilException utilException) {
                    if (utilException.isNamingException() && utilException.returnNamingException() instanceof NameNotFoundException) {
                        object = new ModPropertySet();
                        ((ModPropertySet)object).addProperty(0, "objectclass", radContainerObjList);
                        ((ModPropertySet)object).addProperty(0, "cn", "Resource Access Descriptor");
                        ((ModPropertySet)object).addProperty(0, "orclownerguid", string3);
                        Util.ldapAdd(dirContext, string2, (ModPropertySet)object);
                    }
                    throw utilException;
                }
                string = null;
                object = null;
                LDIFRecord lDIFRecord = modPropertySet.getModProperty();
                try {
                    string = lDIFRecord.getAttribute("orclresourcename").getValue();
                    if (string == null) {
                        throw new UtilException("ModPropertySet does not contain orclresourcename");
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw new UtilException("ModPropertySet does not contain orclresourcename");
                }
                try {
                    object = lDIFRecord.getAttribute("orclresourcetypename").getValue();
                    if (object == null) {
                        throw new UtilException("ModPropertySet does not contain orclresourcetypename");
                    }
                    break block13;
                }
                catch (NullPointerException nullPointerException) {
                    throw new UtilException("ModPropertySet does not contain orclresourcetypename");
                }
            }
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  propType");
        }
        string2 = "orclresourcename=" + string + "+" + "orclresourcetypename=" + (String)object + "," + string2;
        modPropertySet.addProperty(0, "orclownerguid", string3);
        modPropertySet.addProperty(0, "objectclass", radObjList);
        Util.ldapAdd(dirContext, string2, modPropertySet);
    }

    public void setProperties(DirContext dirContext, ModificationItem[] modificationItemArray) throws UtilException {
        this.resolve(dirContext);
        Util.setEntryDetails(dirContext, this.entryDN, modificationItemArray);
    }

    public void setProperties(DirContext dirContext, ModPropertySet modPropertySet) throws UtilException {
        this.resolve(dirContext);
        try {
            super.setProperties(dirContext, modPropertySet);
        }
        catch (UtilException utilException) {
            if (utilException.hasPasswordPolicyError()) {
                int n = utilException.getPasswordPolicyErrorCode();
                switch (n) {
                    case 9001: {
                        throw new AccountLockedException("The account is locked", utilException.returnNamingException());
                    }
                    case 9011: {
                        throw new AcctIPLockedException("The account is locked from this IP address", utilException.returnNamingException());
                    }
                    case 9050: {
                        throw new AccountDisabledException("The account has been disabled", utilException.returnNamingException());
                    }
                    case 9053: {
                        throw new AccountInactiveException("The account is inactive", utilException.returnNamingException());
                    }
                    case 9003: {
                        throw new MinimumLengthException("The password does not satisfy the minimum length", utilException.returnNamingException());
                    }
                    case 9004: {
                        throw new NumericCharacterException("The password requires at least one numeric value", utilException.returnNamingException());
                    }
                    case 9006: {
                        throw new PasswordInHistoryException("Cannot change to a previously used password", utilException.returnNamingException());
                    }
                    case 9007: {
                        throw new IllegalValueException("Illegal password value", utilException.returnNamingException());
                    }
                    case 9005: {
                        throw new PasswordNullException("Password cannot be null", utilException.returnNamingException());
                    }
                }
                throw new PasswordPolicyException("Password policy error encountered: " + utilException.returnNamingException().toString(), utilException.returnNamingException());
            }
            throw utilException;
        }
    }

    public PropertySetCollection getProperties(DirContext dirContext, String[] stringArray) throws UtilException {
        return this.getProperties(dirContext, stringArray, true);
    }

    public PropertySetCollection getProperties(String[] stringArray) throws UtilException {
        throw new UtilException("This operation has been desupported");
    }

    public PropertySetCollection getProperties(String[] stringArray, boolean bl) throws UtilException {
        throw new UtilException("This operation has been desupported");
    }

    public PropertySetCollection getProperties(DirContext dirContext, String[] stringArray, boolean bl) throws UtilException {
        if (this.entryEnum != null) {
            this.entryPsc = new PropertySetCollection(this.enumBase, this.entryEnum);
            this.entryEnum = null;
        }
        return super.getProperties(dirContext, stringArray, bl);
    }

    private void getCommonAttrsFromSubscriber(DirContext dirContext, Subscriber subscriber, String string) throws UtilException {
        String[] stringArray = subscriber.getCommonAttrs(dirContext);
        this.userNickNameAttr = stringArray[0];
        this.userPrincipalAttr = stringArray[2];
        this.userNameWinAttr = stringArray[3];
        int n = 4;
        if (string == null) {
            int n2 = stringArray.length - 4;
            this.userSearchBase = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.userSearchBase[n3] = stringArray[n++];
                ++n3;
            }
            return;
        }
        boolean bl = false;
        while (n < stringArray.length) {
            String string2 = Util.normalizeDN(stringArray[n]);
            if (string2.equals(Util.normalizeDN(string))) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new UtilException("Invalid user search base");
        }
        this.userSearchBase = new String[1];
        this.userSearchBase[0] = string;
    }

    private boolean sameCtxUser(DirContext dirContext) {
        try {
            Hashtable<?, ?> hashtable = dirContext.getEnvironment();
            String string = (String)hashtable.get("java.naming.security.principal");
            return string.equalsIgnoreCase(this.entryDN);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void resolve(DirContext dirContext) throws UtilException {
        if (!this.validated) {
            if (dirContext == null) {
                throw new UtilException(resBundle.getString("PARAMETER_NULL") + ": DirContext");
            }
            if (this.userIdType == Util.IDTYPE_SIMPLE || this.userIdType == Util.IDTYPE_WINDOWS || this.userIdType == Util.IDTYPE_KERB_PRINCIPAL) {
                try {
                    int n;
                    int n2;
                    String[] stringArray;
                    if (this.subscriber == null) {
                        stringArray = new RootOracleContext(dirContext);
                        this.subscriber = stringArray.getSubscriber(dirContext, this.subIdType, this.subIdName, new String[0]);
                    }
                    this.getCommonAttrsFromSubscriber(dirContext, this.subscriber, this.inSearchBase);
                    if (this.attrList != null) {
                        n2 = this.attrList.length + 1;
                        stringArray = new String[n2];
                        n = 0;
                        while (n < this.attrList.length) {
                            stringArray[n] = this.attrList[n];
                            ++n;
                        }
                        stringArray[this.attrList.length] = "orclguid";
                    } else {
                        stringArray = new String[]{"orclguid"};
                    }
                    n2 = 0;
                    n = 0;
                    while (n < this.userSearchBase.length) {
                        String string = this.userSearchBase[n];
                        String string2 = this.userNickNameAttr;
                        if (this.userIdType == Util.IDTYPE_WINDOWS) {
                            string2 = this.userNameWinAttr;
                        } else if (this.userIdType == Util.IDTYPE_KERB_PRINCIPAL) {
                            string2 = this.userPrincipalAttr;
                        }
                        NamingEnumeration namingEnumeration = (NamingEnumeration)Util.getEntryDetails(dirContext, string, "(&(objectclass=*)(" + string2 + "=" + this.inUserId + "))", 2, stringArray, false);
                        boolean bl = namingEnumeration.hasMoreElements();
                        if (!bl && n == this.userSearchBase.length - 1 && n2 == 0) {
                            throw new UtilException("User does not exist - SIMPLE NAME = " + this.inUserId);
                        }
                        if (bl) {
                            if (n2 != 0) {
                                throw new MultipleUserException("Multiple Users found with Simple Name = " + this.inUserId);
                            }
                            SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                            n2 = 1;
                            this.entryDN = string.equals("") ? new String(searchResult.getName()) : new String(searchResult.getName() + "," + string);
                            this.entryGUID = (String)searchResult.getAttributes().get("orclguid").get(0);
                            if (namingEnumeration.hasMoreElements()) {
                                throw new MultipleUserException("Multiple Users found with Simple Name = " + this.inUserId);
                            }
                            this.entryPsc = new PropertySetCollection(string, searchResult, true);
                        }
                        this.validated = true;
                        ++n;
                    }
                }
                catch (NamingException namingException) {
                    if (namingException instanceof CommunicationException) {
                        throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                    }
                    throw new NoSuchUserException("Error encountered when resolving user - SIMPLE NAME = " + this.inUserId, namingException);
                }
            }
            if (this.userIdType == Util.IDTYPE_GUID) {
                try {
                    SearchResult searchResult;
                    NamingEnumeration namingEnumeration = (NamingEnumeration)Util.getEntryDetails(dirContext, "", "(orclguid=" + this.inUserId + ")", 2, this.attrList, false);
                    if (!namingEnumeration.hasMoreElements()) {
                        throw new UtilException("User does not exist - GUID = " + this.inUserId);
                    }
                    this.entryEnum = searchResult = (SearchResult)namingEnumeration.nextElement();
                    this.entryDN = new String(searchResult.getName());
                    this.entryGUID = this.inUserId;
                    this.enumBase = "";
                    this.validated = true;
                }
                catch (NamingException namingException) {
                    if (namingException instanceof CommunicationException) {
                        throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                    }
                    throw new NoSuchUserException("Error encountered when resolving user - GUID = " + this.inUserId, namingException);
                }
            }
            if (this.userIdType == Util.IDTYPE_DN) {
                try {
                    SearchResult searchResult;
                    NamingEnumeration namingEnumeration = (NamingEnumeration)Util.getEntryDetails(dirContext, this.inUserId, "(objectclass=*)", 0, this.attrList, false);
                    if (!namingEnumeration.hasMoreElements()) {
                        throw new UtilException("User does not exist - DN = " + this.inUserId);
                    }
                    this.entryEnum = searchResult = (SearchResult)namingEnumeration.nextElement();
                    this.entryDN = this.inUserId;
                    this.enumBase = this.inUserId;
                    this.validated = true;
                }
                catch (NamingException namingException) {
                    if (namingException instanceof CommunicationException) {
                        throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                    }
                    throw new NoSuchUserException("Error encountered when resolving user - DN = " + this.inUserId, namingException);
                }
            }
        }
    }

    public String getDN(DirContext dirContext) throws UtilException {
        return super.getDN(dirContext);
    }

    public String getDn(DirContext dirContext) throws UtilException {
        return super.getDN(dirContext);
    }

    public String getDn() throws UtilException {
        if (!this.validated) {
            throw new UtilException("This operation has been desupported");
        }
        return super.getDN(null);
    }

    public String getDN() throws UtilException {
        return this.getDn();
    }

    public String locateSubscriber(DirContext dirContext) throws UtilException {
        Object object;
        NamingEnumeration<? extends Attribute> namingEnumeration;
        String[] stringArray;
        Serializable serializable;
        Object object2;
        String string = null;
        this.resolve(dirContext);
        try {
            object2 = new String[]{"orclsubscribersearchbase"};
            serializable = dirContext.getAttributes(commonDN, (String[])object2);
            stringArray = serializable.getAll();
            while (stringArray.hasMore()) {
                namingEnumeration = stringArray.next();
                object = namingEnumeration.getAll();
                if (!namingEnumeration.getID().equals("orclsubscribersearchbase")) continue;
                string = (String)object.next();
            }
        }
        catch (NamingException namingException) {
            throw new InvalidRootOrclctxException(resBundle.getString("INVALID_ROOT_CTX"));
        }
        object2 = Util.normalizeDN(this.entryDN);
        serializable = new SearchControls();
        ((SearchControls)serializable).setSearchScope(2);
        stringArray = null;
        try {
            namingEnumeration = dirContext.search(string, "objectclass=orclSubscriber", (SearchControls)serializable);
            object = new Vector();
            while (namingEnumeration.hasMore()) {
                ((Vector)object).addElement(((SearchResult)namingEnumeration.next()).getName() + "," + string);
            }
            if (((Vector)object).size() == 0) {
                throw new SubscriberNotFoundException(resBundle.getString("NO_SUBSCRIBER_FOUND") + ":  " + string);
            }
            stringArray = Util.vector2StrArray((Vector)object);
            String[] stringArray2 = new String[]{"orclcommonusersearchbase"};
            int n = 0;
            while (n < stringArray.length) {
                Attributes attributes = dirContext.getAttributes(commonDN + "," + stringArray[n], stringArray2);
                namingEnumeration = attributes.getAll();
                String string2 = null;
                if (namingEnumeration.hasMore()) {
                    Attribute attribute = namingEnumeration.next();
                    NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                    string2 = Util.normalizeDN((String)namingEnumeration2.next());
                }
                if (((String)object2).endsWith(string2)) {
                    return stringArray[n];
                }
                ++n;
            }
            throw new SubscriberNotFoundException(resBundle.getString("NO_MATCHING_SUBSCRIBER"));
        }
        catch (NamingException namingException) {
            throw new GeneralErrorException(resBundle.getString("CANNOT_FIND_SUBSCRIBER") + ":  " + this.entryDN, namingException);
        }
    }

    public String getGUID() throws UtilException {
        if (this.entryGUID == null) {
            throw new UtilException("This operation has been desupported");
        }
        return this.entryGUID;
    }

    public String getGUID(DirContext dirContext) throws UtilException {
        this.resolve(dirContext);
        if (this.entryGUID == null) {
            String[] stringArray = new String[]{"orclguid"};
            PropertySetCollection propertySetCollection = Util.ldapSearch(dirContext, this.entryDN, "(objectclass=*)", 0, stringArray);
            this.entryGUID = (String)propertySetCollection.getPropertySet(0).getProperty(0).getValue(0);
        }
        return this.entryGUID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void authenticateUser(DirContext dirContext, int n, Object object) throws UtilException {
        Control[] controlArray;
        if (n != CREDTYPE_PASSWD) throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  authType");
        String string = new String("userpassword");
        String string2 = (String)object;
        if (dirContext instanceof LdapContext) {
            try {
                controlArray = new Control[]{new PasswordPolicyControl()};
                ((LdapContext)dirContext).setRequestControls(controlArray);
            }
            catch (NamingException namingException) {
                if (!(namingException instanceof CommunicationException)) throw new UtilException("Unable to set Password Policy controls");
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
        }
        try {
            this.authenticateUser(dirContext, string, string2);
        }
        catch (UtilException utilException) {
            if (this.toBeAutoProvisioned) {
                if (!utilException.isNamingException()) throw utilException;
                NamingException namingException = utilException.returnNamingException();
                if (namingException instanceof NameNotFoundException) {
                    this.resolve(dirContext);
                    this.toBeAutoProvisioned = false;
                    return;
                }
            }
            if (!utilException.hasPasswordPolicyError()) throw utilException;
            int n2 = utilException.getPasswordPolicyErrorCode();
            switch (n2) {
                case 9000: {
                    throw new PasswordExpiredException("Password has expired", utilException.returnNamingException());
                }
                case 9001: {
                    throw new AccountLockedException("The account is locked", utilException.returnNamingException());
                }
                case 9011: {
                    throw new AcctIPLockedException("The account is locked from this IP address", utilException.returnNamingException());
                }
                case 9050: {
                    throw new AccountDisabledException("The account has been disabled", utilException.returnNamingException());
                }
                case 9053: {
                    throw new AccountInactiveException("The account is inactive", utilException.returnNamingException());
                }
                case 9005: {
                    throw new PasswordNullException("Password is null", utilException.returnNamingException());
                }
            }
            throw new PasswordPolicyException("Password policy error encountered: " + utilException.returnNamingException().toString(), utilException.returnNamingException());
        }
        if (!(dirContext instanceof LdapContext)) return;
        try {
            controlArray = ((LdapContext)dirContext).getResponseControls();
            String string3 = null;
            if (controlArray == null || controlArray.length <= 0) return;
            byte[] byArray = controlArray[0].getEncodedValue();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            System.out.println(byteArrayOutputStream.toString());
            string3 = controlArray[0].getID();
            if (string3.equals("2.16.840.1.113894.1.8.7")) {
                throw new PasswordExpiredWarningException("User Password Expire Warning");
            }
            if (string3.equals("2.16.840.1.113894.1.8.8")) {
                throw new GraceLoginException("User in Grace Login mode");
            }
            if (!string3.equals("2.16.840.1.113894.1.8.9")) return;
            throw new MustChangeException("User password must be changed");
        }
        catch (NamingException namingException) {
            if (!(namingException instanceof CommunicationException)) return;
            throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
        }
    }

    public void authenticateUser(DirContext dirContext, String string, String string2) throws UtilException {
        if (!this.toBeAutoProvisioned) {
            this.resolve(dirContext);
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[0]);
        searchControls.setSearchScope(0);
        try {
            byte[] byArray = string2.getBytes("UTF-8");
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(this.entryDN, "(" + string + "={0})", new Object[]{byArray}, searchControls);
            if (!namingEnumeration.hasMore()) {
                throw new AuthFailureException(resBundle.getString("UNABLE_AUTHENTICATE_USER") + ": " + this.entryDN);
            }
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), exception);
            }
            if (exception instanceof AuthFailureException) {
                throw (AuthFailureException)exception;
            }
            throw new AuthFailureException(resBundle.getString("UNABLE_AUTHENTICATE_USER") + ": " + this.entryDN, exception);
        }
    }

    public Group[] getGroupMembership(DirContext dirContext, String[] stringArray, boolean bl) throws UtilException {
        this.resolve(dirContext);
        PropertySetCollection propertySetCollection = Util.getGroupMembership(dirContext, this, stringArray, bl);
        if (propertySetCollection == null) {
            return null;
        }
        Group[] groupArray = new Group[propertySetCollection.size()];
        int n = 0;
        while (n < groupArray.length) {
            groupArray[n] = new Group(dirContext, propertySetCollection.getPropertySet(n).getDN(), propertySetCollection.getPropertySet(n));
            ++n;
        }
        return groupArray;
    }

    public boolean isProvisioned() {
        return !this.toBeAutoProvisioned;
    }
}

